/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.capability;

import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import melonslise.locks.Locks;
import melonslise.locks.common.capability.ILockableHandler;
import melonslise.locks.common.capability.ILockableStorage;
import melonslise.locks.common.init.LocksCapabilities;
import melonslise.locks.common.util.Lockable;
import melonslise.locks.common.util.LocksUtil;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.chunk.Chunk;

public class LockableStorage
implements ILockableStorage {
    public static final ResourceLocation ID = new ResourceLocation("locks", "lockable_storage");
    public final Chunk chunk;
    public Int2ObjectMap<Lockable> lockables = new Int2ObjectLinkedOpenHashMap();

    public LockableStorage(Chunk chunk) {
        this.chunk = chunk;
    }

    @Override
    public Int2ObjectMap<Lockable> get() {
        return this.lockables;
    }

    @Override
    public void add(Lockable lkb) {
        this.lockables.put(lkb.networkID, (Object)lkb);
        this.chunk.func_76630_e();
    }

    @Override
    public void remove(int id) {
        this.lockables.remove(id);
        this.chunk.func_76630_e();
    }

    public NBTTagList serializeNBT() {
        NBTTagList list = new NBTTagList();
        for (Lockable lkb : this.lockables.values()) {
            list.func_74742_a((NBTBase)LocksUtil.writeLockableToNBT(lkb));
        }
        return list;
    }

    public void deserializeNBT(NBTTagList nbt) {
        ILockableHandler handler = (ILockableHandler)this.chunk.func_177412_p().getCapability(LocksCapabilities.LOCKABLE_HANDLER, null);
        Int2ObjectMap<Lockable> loadedLockables = handler.getLoaded();
        for (int a = 0; a < nbt.func_74745_c(); ++a) {
            NBTTagCompound nbt1 = nbt.func_150305_b(a);
            Lockable lkb = (Lockable)loadedLockables.get(nbt1.func_74762_e("id"));
            if (lkb == loadedLockables.defaultReturnValue()) {
                lkb = LocksUtil.readLockableFromNBT(nbt1);
                if (Locks.debug) {
                    Locks.logger.debug("Storage deserializing with id: " + lkb.networkID + " ::: " + lkb.toString());
                }
            }
            this.lockables.put(lkb.networkID, (Object)lkb);
        }
    }
}

